
//
// Apple II display lookup tables
//

#include <coemain.h>

#include "Emu6502.h"


const byte colormap[] = {
       (byte)0x00,(byte)0x00,(byte)0x00, (byte)0xff,(byte)0x00,(byte)0xff, (byte)0x00,(byte)0x00,(byte)0x7f, (byte)0x7f,(byte)0x00,(byte)0x7f,
       (byte)0x00,(byte)0x7f,(byte)0x00, (byte)0x7f,(byte)0x7f,(byte)0x7f, (byte)0x00,(byte)0x00,(byte)0xbf, (byte)0x00,(byte)0x00,(byte)0xff,
       (byte)0xbf,(byte)0x7f,(byte)0x00, (byte)0xff,(byte)0xbf,(byte)0x00, (byte)0xbf,(byte)0xbf,(byte)0xbf, (byte)0xff,(byte)0x7f,(byte)0x7f,
       (byte)0x00,(byte)0xff,(byte)0x00, (byte)0xff,(byte)0xff,(byte)0x00, (byte)0x00,(byte)0xbf,(byte)0x7f, (byte)0xff,(byte)0xff,(byte)0xff
   };

const TUint32 loresColor[16] = {
	(0x000000), (0xff00ff), (0x00007f), (0x7f007f),
	(0x007f00), (0x7f7f7f), (0x0000bf), (0x0000ff),
	(0xbf7f00), (0xffbf00), (0xbfbfbf), (0xff7f7f),
	(0x00ff00), (0xffff00), (0x00bf7f), (0xffffff),
};

const int text_lut[24] = {
	0x000, 0x080, 0x100, 0x180, 0x200, 0x280, 0x300, 0x380,
	0x028, 0x0a8, 0x128, 0x1a8, 0x228, 0x2a8, 0x328, 0x3a8,
	0x050, 0x0d0, 0x150, 0x1d0, 0x250, 0x2d0, 0x350, 0x3d0
};

const int hires_lut[192] = {
	0x0000, 0x0400, 0x0800, 0x0c00, 0x1000, 0x1400, 0x1800, 0x1c00,
	0x0080, 0x0480, 0x0880, 0x0c80, 0x1080, 0x1480, 0x1880, 0x1c80,
	0x0100, 0x0500, 0x0900, 0x0d00, 0x1100, 0x1500, 0x1900, 0x1d00,
	0x0180, 0x0580, 0x0980, 0x0d80, 0x1180, 0x1580, 0x1980, 0x1d80,
	0x0200, 0x0600, 0x0a00, 0x0e00, 0x1200, 0x1600, 0x1a00, 0x1e00,
	0x0280, 0x0680, 0x0a80, 0x0e80, 0x1280, 0x1680, 0x1a80, 0x1e80,
	0x0300, 0x0700, 0x0b00, 0x0f00, 0x1300, 0x1700, 0x1b00, 0x1f00,
	0x0380, 0x0780, 0x0b80, 0x0f80, 0x1380, 0x1780, 0x1b80, 0x1f80,
	0x0028, 0x0428, 0x0828, 0x0c28, 0x1028, 0x1428, 0x1828, 0x1c28,
	0x00a8, 0x04a8, 0x08a8, 0x0ca8, 0x10a8, 0x14a8, 0x18a8, 0x1ca8,
	0x0128, 0x0528, 0x0928, 0x0d28, 0x1128, 0x1528, 0x1928, 0x1d28,
	0x01a8, 0x05a8, 0x09a8, 0x0da8, 0x11a8, 0x15a8, 0x19a8, 0x1da8,
	0x0228, 0x0628, 0x0a28, 0x0e28, 0x1228, 0x1628, 0x1a28, 0x1e28,
	0x02a8, 0x06a8, 0x0aa8, 0x0ea8, 0x12a8, 0x16a8, 0x1aa8, 0x1ea8,
	0x0328, 0x0728, 0x0b28, 0x0f28, 0x1328, 0x1728, 0x1b28, 0x1f28,
	0x03a8, 0x07a8, 0x0ba8, 0x0fa8, 0x13a8, 0x17a8, 0x1ba8, 0x1fa8,
	0x0050, 0x0450, 0x0850, 0x0c50, 0x1050, 0x1450, 0x1850, 0x1c50,
	0x00d0, 0x04d0, 0x08d0, 0x0cd0, 0x10d0, 0x14d0, 0x18d0, 0x1cd0,
	0x0150, 0x0550, 0x0950, 0x0d50, 0x1150, 0x1550, 0x1950, 0x1d50,
	0x01d0, 0x05d0, 0x09d0, 0x0dd0, 0x11d0, 0x15d0, 0x19d0, 0x1dd0,
	0x0250, 0x0650, 0x0a50, 0x0e50, 0x1250, 0x1650, 0x1a50, 0x1e50,
	0x02d0, 0x06d0, 0x0ad0, 0x0ed0, 0x12d0, 0x16d0, 0x1ad0, 0x1ed0,
	0x0350, 0x0750, 0x0b50, 0x0f50, 0x1350, 0x1750, 0x1b50, 0x1f50,
	0x03d0, 0x07d0, 0x0bd0, 0x0fd0, 0x13d0, 0x17d0, 0x1bd0, 0x1fd0
};


const byte texels[128][8] = {
 0x70,0x88,0xA8,0xE8,0x68,0x08,0xF0,0x00,0x20,0x50,0x88,0x88,0xF8,0x88,0x88,0x00
,0x78,0x88,0x88,0x78,0x88,0x88,0x78,0x00,0x70,0x88,0x08,0x08,0x08,0x88,0x70,0x00
,0x78,0x88,0x88,0x88,0x88,0x88,0x78,0x00,0xF8,0x08,0x08,0x78,0x08,0x08,0xF8,0x00
,0xF8,0x08,0x08,0x78,0x08,0x08,0x08,0x00,0xF0,0x08,0x08,0x08,0xC8,0x88,0xF0,0x00
,0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,0x70,0x20,0x20,0x20,0x20,0x20,0x70,0x00
,0x80,0x80,0x80,0x80,0x80,0x88,0x70,0x00,0x88,0x48,0x28,0x18,0x28,0x48,0x88,0x00
,0x08,0x08,0x08,0x08,0x08,0x08,0xF8,0x00,0x88,0xD8,0xA8,0xA8,0x88,0x88,0x88,0x00
,0x88,0x88,0x98,0xA8,0xC8,0x88,0x88,0x00,0x70,0x88,0x88,0x88,0x88,0x88,0x70,0x00
,0x78,0x88,0x88,0x78,0x08,0x08,0x08,0x00,0x70,0x88,0x88,0x88,0xA8,0x48,0xB0,0x00
,0x78,0x88,0x88,0x78,0x28,0x48,0x88,0x00,0x70,0x88,0x08,0x70,0x80,0x88,0x70,0x00
,0xF8,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00
,0x88,0x88,0x88,0x88,0x88,0x50,0x20,0x00,0x88,0x88,0x88,0xA8,0xA8,0xD8,0x88,0x00
,0x88,0x88,0x50,0x20,0x50,0x88,0x88,0x00,0x88,0x88,0x50,0x20,0x20,0x20,0x20,0x00
,0xF8,0x80,0x40,0x20,0x10,0x08,0xF8,0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0xF8,0x00
,0x00,0x08,0x10,0x20,0x40,0x80,0x00,0x00,0xF8,0xC0,0xC0,0xC0,0xC0,0xC0,0xF8,0x00
,0x00,0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x20,0x20,0x20,0x00,0x20,0x00
,0x50,0x50,0x50,0x00,0x00,0x00,0x00,0x00,0x50,0x50,0xF8,0x50,0xF8,0x50,0x50,0x00
,0x20,0xF0,0x28,0x70,0xA0,0x78,0x20,0x00,0x18,0x98,0x40,0x20,0x10,0xC8,0xC0,0x00
,0x10,0x28,0x28,0x10,0xA8,0x48,0xB0,0x00,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00
,0x20,0x10,0x08,0x08,0x08,0x10,0x20,0x00,0x20,0x40,0x80,0x80,0x80,0x40,0x20,0x00
,0x20,0xA8,0x70,0x20,0x70,0xA8,0x20,0x00,0x00,0x20,0x20,0xF8,0x20,0x20,0x00,0x00
,0x00,0x00,0x00,0x00,0x20,0x20,0x10,0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x80,0x40,0x20,0x10,0x08,0x00,0x00
,0x70,0x88,0xC8,0xA8,0x98,0x88,0x70,0x00,0x20,0x30,0x20,0x20,0x20,0x20,0x70,0x00
,0x70,0x88,0x80,0x60,0x10,0x08,0xF8,0x00,0xF8,0x80,0x40,0x60,0x80,0x88,0x70,0x00
,0x40,0x60,0x50,0x48,0xF8,0x40,0x40,0x00,0xF8,0x08,0x78,0x80,0x80,0x88,0x70,0x00
,0xE0,0x10,0x08,0x78,0x88,0x88,0x70,0x00,0xF8,0x80,0x40,0x20,0x10,0x10,0x10,0x00
,0x70,0x88,0x88,0x70,0x88,0x88,0x70,0x00,0x70,0x88,0x88,0xF0,0x80,0x40,0x38,0x00
,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x20,0x10,0x00
,0x40,0x20,0x10,0x08,0x10,0x20,0x40,0x00,0x00,0x00,0xF8,0x00,0xF8,0x00,0x00,0x00
,0x10,0x20,0x40,0x80,0x40,0x20,0x10,0x00,0x70,0x88,0x40,0x20,0x20,0x00,0x20,0x00
,0x70,0x88,0xA8,0xE8,0x68,0x08,0xF0,0x00,0x20,0x50,0x88,0x88,0xF8,0x88,0x88,0x00
,0x78,0x88,0x88,0x78,0x88,0x88,0x78,0x00,0x70,0x88,0x08,0x08,0x08,0x88,0x70,0x00
,0x78,0x88,0x88,0x88,0x88,0x88,0x78,0x00,0xF8,0x08,0x08,0x78,0x08,0x08,0xF8,0x00
,0xF8,0x08,0x08,0x78,0x08,0x08,0x08,0x00,0xF0,0x08,0x08,0x08,0xC8,0x88,0xF0,0x00
,0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,0x70,0x20,0x20,0x20,0x20,0x20,0x70,0x00
,0x80,0x80,0x80,0x80,0x80,0x88,0x70,0x00,0x88,0x48,0x28,0x18,0x28,0x48,0x88,0x00
,0x08,0x08,0x08,0x08,0x08,0x08,0xF8,0x00,0x88,0xD8,0xA8,0xA8,0x88,0x88,0x88,0x00
,0x88,0x88,0x98,0xA8,0xC8,0x88,0x88,0x00,0x70,0x88,0x88,0x88,0x88,0x88,0x70,0x00
,0x78,0x88,0x88,0x78,0x08,0x08,0x08,0x00,0x70,0x88,0x88,0x88,0xA8,0x48,0xB0,0x00
,0x78,0x88,0x88,0x78,0x28,0x48,0x88,0x00,0x70,0x88,0x08,0x70,0x80,0x88,0x70,0x00
,0xF8,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00
,0x88,0x88,0x88,0x88,0x88,0x50,0x20,0x00,0x88,0x88,0x88,0xA8,0xA8,0xD8,0x88,0x00
,0x88,0x88,0x50,0x20,0x50,0x88,0x88,0x00,0x88,0x88,0x50,0x20,0x20,0x20,0x20,0x00
,0xF8,0x80,0x40,0x20,0x10,0x08,0xF8,0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0xF8,0x00
,0x00,0x08,0x10,0x20,0x40,0x80,0x00,0x00,0xF8,0xC0,0xC0,0xC0,0xC0,0xC0,0xF8,0x00
,0x00,0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00
,0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00
,0x08,0x08,0x78,0x88,0x88,0x88,0x78,0x00,0x00,0x00,0xF0,0x08,0x08,0x08,0xF0,0x00
,0x80,0x80,0xF0,0x88,0x88,0x88,0xF0,0x00,0x00,0x00,0x70,0x88,0xF8,0x08,0xF0,0x00
,0x60,0x90,0x10,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x70,0x88,0x88,0xF0,0x80,0x70
,0x08,0x08,0x78,0x88,0x88,0x88,0x88,0x00,0x20,0x00,0x30,0x20,0x20,0x20,0x70,0x00
,0x40,0x00,0x60,0x40,0x40,0x40,0x48,0x30,0x08,0x08,0x88,0x48,0x38,0x48,0x88,0x00
,0x30,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00,0x00,0x58,0xA8,0xA8,0xA8,0xA8,0x00
,0x00,0x00,0x78,0x88,0x88,0x88,0x88,0x00,0x00,0x00,0x70,0x88,0x88,0x88,0x70,0x00
,0x00,0x00,0x78,0x88,0x88,0x78,0x08,0x08,0x00,0x00,0xF0,0x88,0x88,0xF0,0x80,0x80
,0x00,0x00,0xE8,0x18,0x08,0x08,0x08,0x00,0x00,0x00,0xF0,0x08,0x70,0x80,0x78,0x00
,0x10,0x10,0xF8,0x10,0x10,0x90,0x60,0x00,0x00,0x00,0x88,0x88,0x88,0xC8,0xB0,0x00
,0x00,0x00,0x88,0x88,0x88,0x50,0x20,0x00,0x00,0x00,0x88,0xA8,0xA8,0xA8,0x50,0x00
,0x00,0x00,0x88,0x50,0x20,0x50,0x88,0x00,0x00,0x00,0x88,0x88,0x88,0xF0,0x80,0x70
,0x00,0x00,0xF8,0x40,0x20,0x10,0xF8,0x00,0xE0,0x30,0x30,0x18,0x30,0x30,0xE0,0x00
,0x20,0x20,0x20,0x00,0x20,0x20,0x20,0x00,0x38,0x60,0x60,0xC0,0x60,0x60,0x38,0x00
,0xB0,0x68,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

class TAppleHiresLUT
{
private:
	byte colors_lut[256*4*2*7];
public:
	TAppleHiresLUT();
	byte operator[](int index) const { return colors_lut[index]; }
};

const int AC_WHITE  = 3;
const int AC_RED    = 1;
const int AC_GREEN  = 2;
const int AC_BLUE   = 1;
const int AC_ORANGE = 2;

    /**
      * This function makes the color lookup table for hires mode.
      * We make a table of 1024 * 2 * 7 entries.
      * Why? Because we assume each color byte has 10 bits
      * (8 real bits + 1 on each side) and we need different colors
      * for odd and even addresses (2) and each byte displays 7 pixels.
      */
    TAppleHiresLUT::TAppleHiresLUT()
    {
        int i,j;
        //int c1,c2,c3 = 15;
		const int c1 = AC_RED;
		const int c2 = AC_GREEN;
        int base = 0;

        // go thru odd and even
        for (j=0; j<2; j++)
        {
            // go thru 1024 values
            for (int b1=0; b1<1024; b1++)
            {
                // see if the hi bit is set
				/*
                if ((b1 & 0x80) == 0)
    			{
    			    c1 = 1; c2 = 12;    // red & green
    			} else {
    			    c1 = 7; c2 = 9;     // blue & orange
    			}
				*/
    			// make a value consisting of:
    			// the 8th bit, then bits 0-7, then the 9th bit
    			int b = ((b1 & 0x100) >> 8) | ((b1 & 0x7f) << 1) |
    			    ((b1 & 0x200) >> 1);
    			// go through each pixel
    			for (i=0; i<7; i++)
    			{
					colors_lut[base] = 0; // set it to black first
    			    // is this pixel lit?
                    if (((2<<i)&b) != 0)
                    {
                        // are there pixels lit on both sides of this one?
                        if (((7<<i)&b) == (7<<i))
                            // yes, make it white
                            colors_lut[base] = AC_WHITE;
                        else
                            // no, choose color based on odd/even byte
                            // and odd/even pixel column
                            colors_lut[base] =
                                (byte) ((((j ^ i) & 1) == 0) ? c1 : c2);
                    } else {
                        // are there pixels lit in the previous & next
                        // column but none in this?
                        if (((5<<i)&b) == (5<<i))
                            // color this pixel
                            colors_lut[base] =
                                (byte) ((((j ^ i) & 1) != 0) ? c1 : c2);
                    }
                    base++;
    			}
            }
        }
    }

